# SU(N) scaling extension

This subdirectory extends the core SU(3) RG extraction to multiple
gauge groups.

## Files

* `scripts/extract_beta_N.py` — driver script that samples the
  running coupling for each N in a predefined list, computes the
  numerical β‑function and extracts the one‑loop coefficient β₁.
* `results/` — destination for the generated CSV files and plots.
* `README.md` — this file.

## Usage

From within the `N_scaling` directory install the dependencies (only
necessary once):

```bash
pip install -r ../requirements.txt
```

Then run the N‑scan:

```bash
python scripts/extract_beta_N.py
```

The script will:

1. Sample g(μ) at several scales for each N in its list (by default
   N=2 and N=4).
2. Compute β(g) numerically via finite differences.
3. Fit the data to the theoretical one‑loop form to extract β₁.
4. Write the raw data to `results/g_vs_mu_N.csv`, the numeric β to
   `results/beta_numeric_N.csv` and the fitted β₁ coefficients to
   `results/beta1_vs_N.csv`.
5. Produce two figures: `beta1_scaling.png` showing β₁ vs N with the
   theoretical line 11N/3 and `g_vs_lnmu_N.png` displaying the
   running coupling versus ln μ for each N.

The script prints the fitted β₁ values along with the theoretical
expectations and relative errors.  A fixed random seed makes the
output deterministic.